% Main
clear, close all, clc %clear all

%% config
tic

initialization_main;

%% Generate input

file_format = 'bmp';
file_name = 'name';

[generated_input_before, nr_input_bits,im] = input_data_from_image('h_face.bmp');

% Scrambling, hamming encoding and interleaving

scrambling_and_encoding;


%% Generate packages and modulate

% Generate packages from data sequence, load training sequence and
% guard bits

packages;

% Modulate and use OFDM on each package

modulate_and_OFDM;
    

%% Create header, modulate it and add it to data sequence
    
% Header is created, modulated and upconverted

header_main;

%% Upconversion

% Upconvert and add passband header to data sequence

upconvert;

%Write to .wav-file

%write_to_wav_file(file_name, tx_up_channel,fs)

 
figure()
pwelch(tx_up_channel)
title('Power Spectrum of Transmitted Pass-Band Signal')

%% Simulated channel

% Generate noise and add lag to the input data sequence

%simulated_channel;

%% Real channel

% If we are transmitting over the real channel the wav file need to be
% loaded below

rx_passband = real_channel('64QAM_OFDM_L16_0524_rx.wav');

%% Receiver

% Create training sequences for header

header_training;

% The packages are detected and demodulated

find_and_demod_main;


%% Recreate data sequence

% Training sequence and zero padding removed
package_removal_main

% Here deinterleaving, Hamming decoding and descrambling is done

decoding_and_descrambling;

% Calculate the BER of the received file

BER_calculation;

toc

%% Read image

% Here we read all the images contained in the data sequence, it may
% contain more than one image

read_image(bit_output, nr_input_bits, im)
